package examples.jndi;
import javax.naming.*;

/**
 * A helper class which starts our RMI-IIOP server
 */
public class Startup { 

     /**
      * Our main() method starts things up
      */
     public static void main(String args[]) throws Exception { 

          /*
           * Start up our PKGenerator remote object.  It will
           * automatically export itself.
           */
          PrimaryKeyGenerator generator = new PrimaryKeyGeneratorImpl();

          /*
           * Bind our PKGenerator remote object to the JNDI tree
           */
          Context ctx = new InitialContext(System.getProperties());
          ctx.rebind("PKGenerator", generator);
          System.out.println("PKGenerator bound to JNDI tree.");

          // wait for clients
          synchronized (generator) { 
            generator.wait();
          } 
     } 
}
